<?php 

require( '../sys/inc/core.php' );
include_once '../sys/inc/adm_check.php';
user_access( 'adm_mysql', null, 'index.php?' . SID );
adm_check();

$action = (isset($_GET['action']) ? $_GET['action'] : ''); 
$slug = (isset($_GET['slug']) ? $_GET['slug'] : ''); 

if (isset($_FILES['file']) && is_file($_FILES['file']['tmp_name'])) {
	$sess_id = md5(time()); 

	if (!is_dir(H.'sys/tmp')) {	
		@mkdir(H.'sys/tmp', 0777); 
		@chmod(H.'sys/tmp', 0777); 
	}

	if (!is_file(PATH_PLUGINS . '/index.php')) {
		file_put_contents(PATH_PLUGINS . '/index.php', "<?php \n\n// Index Of");
	}

	if (!copy($_FILES['file']['tmp_name'], H.'sys/tmp/'.$sess_id.'.zip')) {
		$err[] = __('Не удалось загрузить плагин');
	}

	if (is_file(H.'sys/tmp/'.$sess_id.'.zip')) {
		if (!isset($err)) {
			$zip = new ZipArchive();
			$zip->open(H.'sys/tmp/' . $sess_id . '.zip', ZipArchive::CREATE);
			$zip->extractTo(H.'sys/tmp/' . $sess_id);
			$zip->close();

			unlink(H.'sys/tmp/' . $sess_id . '.zip'); 

			$files_list = ds_readdir_files_list(H.'sys/tmp/' . $sess_id); 
			$dires_list = ds_readdir_dir_list(H.'sys/tmp/' . $sess_id); 

			if (!isset($dires_list[0])) {
				$err[] = 'Подходящих плагинов не найдено';
			} else {
				preg_match('/([A-z0-9\_\-]+)\/?$/m', $dires_list[0], $matches); 

				if (isset($matches[1])) {
					$plugin_id = $matches[1]; 
				}
			}

			if (!isset($plugin_id) || !is_file(H.'sys/tmp/' . $sess_id . '/' . $plugin_id . '/' . $plugin_id . '.php')) {
				$err[] = __('Подходящих плагинов не найдено'); 
			}

			if (isset($plugin_id) && is_dir(PATH_PLUGINS . '/' . $plugin_id)) {
				$err[] = __('Такой плагин уже установлен'); 
			}

			if (!isset($err)) {
				if (rename(H.'sys/tmp/' . $sess_id . '/' . $plugin_id, PATH_PLUGINS . '/' . $plugin_id)) {
					delete_dir(H.'sys/tmp/' . $sess_id); 

					$_SESSION['message'] = __('Плагин успешно установлен'); 

					do_event('ds_plugin_installed'); 
					header('Location: ?'); 
					exit;
				} else {
					$err[] = __('Не удалось установить плагин'); 
				}
			}
		}
	}

	if (isset($err)) {
		if (is_dir(H.'sys/tmp/' . $sess_id)) {
			delete_dir(H.'sys/tmp/' . $sess_id); 
		}
		
		if (is_file(H.'sys/tmp/' . $sess_id . '.zip')) {
			unlink(H.'sys/tmp/' . $sess_id . '.zip'); 
		}
	}
} 

if ($action && $slug) {
	if ($action == 'activate') {
		if (ds_plugin_activate($slug)) {
			$_SESSION['message'] = __('Плагин активирован'); 
		}
	}
	
	if ($action == 'deactivate') {
		if (ds_plugin_deactivate($slug)) {
			$_SESSION['message'] = __('Плагин деактивирован'); 
		}
	}

	if ($action == 'remove') {
		if (ds_plugin_remove($slug)) {
			$_SESSION['message'] = __('Плагин удален из системы'); 
		}
	}

	header('Location: ?'); 
	exit;
}

$set[ 'title' ] = __('Плагины');
include_once '../sys/inc/thead.php';

?>
<div class="form-plugins-upload">
	<form action="?" method="POST" enctype="multipart/form-data">
		<input type="file" name="file"><input type="submit" value="Загрузить">
	</form>
</div>
<?
$plugins = new Plugins(); 
$list = $plugins->listPlugins(); 

if (empty($list)) : 
	do_event('ds_plugins_empty'); 
	?>
	<div class="empty empty-plugins">
		<?php echo __('Нет установленных плагинов'); ?>
	</div>
	<?
endif; 

if (!empty($list)) : 
	do_event('ds_plugins_list'); 

	?><div class="list"><?
	foreach($list AS $plugin) 
	{
		$plug_action['activate'] = '<a href="?slug=' . $plugin['slug'] . '&action=' . ($plugin['active'] == 1 ? 'deactivate' : 'activate') . '">' . 
					__($plugin['active'] == 1 ? 'Деактивировать' : 'Активировать') . '</a>';

		if ($plugin['active'] == 0) {
			$plug_action['remove'] = '<a class="ds-link-delete" href="?slug=' . $plugin['slug'] . '&action=remove">' . __('Удалить') . '</a>';
		}

		$plug_action = use_filters('ds_plugin_' . $plugin['slug'] . '_action', $plug_action); 
		$plug_action = use_filters('ds_plugins_action', $plug_action); 
		?>
		<div class="list-item <?php echo ($plugin['active'] == 1 ? 'active' : ''); ?>">
			<div class="list-item-title"><?php echo $plugin['Name']; ?></div>
			<div class="list-item-description"><?php echo $plugin['Full']; ?></div>
			<div class="list-item-action">
				<?php echo join(' | ', $plug_action); ?>
			</div>
		</div>
		<?
	}
	?></div><?
endif; 

include_once '../sys/inc/tfoot.php';