<?php

only_reg();

if ($ank['id'] != $user['id'] || !$gallery || !$photo) {
    header('Location: ?');
    exit;
}

$pid = md5($photo['id']);
$exp_path = H . 'sys/tmp/photo.effects.' . $pid . '.ser';

$exp_default = array(
    'rotate' => 0,
    'filter' => 'none',
    'tint' => 'none',
);

if ($photo['effects']) {
    $exp_default = array_merge($exp_default, unserialize($photo['effects']));
}

$exp_save = (is_file($exp_path) ? unserialize(file_get_contents($exp_path)) : array());

$save = array_merge($exp_default, $exp_save);

$filter = array('greyscale', 'pixelate', 'negative', 'none');
$tint = array('#00ffff', '#0000ff', '#ff00ff', '#808080', '#008000', '#800000', '#00ff00', '#808000', '#800080', '#ff0000', '#c0c0c0', '#008080', '#ffff00');

$effect = (isset($_GET['effect']) ? $_GET['effect'] : false);
$action = (isset($_GET['action']) ? $_GET['action'] : false);

if ($effect && $action) {
    if ($effect == 'rotate') {
        $com = ($action == 'right' ? 90 : -90);

        if (($save['rotate'] + $com) == 360) {
            $save['rotate'] = 0;
        } elseif (($save['rotate'] + $com) == -90) {
            $save['rotate'] = 270;
        } else {
            $save['rotate'] += $com;
        }
    } elseif ($effect == 'filter') {
        if (in_array($action, $filter)) {
            $save['filter'] = $action;
        }
    } elseif ($effect == 'tint') {
        if (in_array($action, $tint) || $action == 'none') {
            $save['tint'] = urldecode($action);
        }
    }


    file_put_contents($exp_path, serialize($save));
    header('Location: ?func=' . $func);
    exit;
}

if (isset($_POST['ok'])) {
    db::query("UPDATE `gallery_foto` SET `effects` = '" . serialize($save) . "' WHERE `id` = '$photo_id' LIMIT 1");

    if (is_file($exp_path))
        unlink($exp_path);

    $cached = array(50, 128, 640);
    $cache = new Cache(1);

    foreach ($cached AS $size) {
        $cacheId = 'photo.' . $photo_id . '.' . $size;
        $cache->delete($cacheId);
    }

    $_SESSION['message'] = 'Изменения успешно приняты';
    header('Location: ?');
    exit;
}
$set['title'] = 'Фоторедактор';
include_once H . 'sys/inc/thead.php';
title();
aut();
err();
?>
<div class="foot">
    <img src="/style/icons/str2.gif">
    <a href="/info.php?id=<?php echo $ank['id']; ?>"><?php echo $ank['nick']; ?></a> |
    <a href="/foto/<?php echo $ank['id']; ?>/">Фотоальбомы</a> |
    <a href="/foto/<?php echo $ank['id']; ?>/<?php echo $gallery_id; ?>/"><?php echo text($gallery['name']); ?></a> |
    <a href="/foto/<?php echo $ank['id']; ?>/<?php echo $gallery_id; ?>/<?php echo $photo_id; ?>/"><?php echo text($photo['name']); ?></a>
    |
    <b>Фоторедактор</b>
</div>

<form action="?func=photo.effects" method="post" enctype="multipart/form-data">
    <div class="photo_effects">
        <img class="photo_effects_image" src="/foto/effects/<?php echo $pid; ?>/<?php echo $photo['id']; ?>.jpg">
    </div>

    <div class="photo_effects">
        Повернуть:
        <a href="?func=photo.effects&amp;effect=rotate&amp;action=left"><img
                    src="/style/icons/arrow_rotate_anticlockwise.png"/></a>
        <a href="?func=photo.effects&amp;effect=rotate&amp;action=right"><img
                    src="/style/icons/arrow_rotate_clockwise.png"/></a>
    </div>

    <div class="photo_effects_title">Фильтры</div>

    <div class="photo_effects">
        <a href="?func=photo.effects&amp;effect=filter&amp;action=none"><img
                    class="<?php echo($save['filter'] == 'none' ? 'photo_effects_active' : ''); ?>"
                    src="/foto/res/images/default.jpg"/></a>
        <a href="?func=photo.effects&amp;effect=filter&amp;action=greyscale"><img
                    class="<?php echo($save['filter'] == 'greyscale' ? 'photo_effects_active' : ''); ?>"
                    src="/foto/res/images/greyscale.jpg"/></a>
        <a href="?func=photo.effects&amp;effect=filter&amp;action=negative"><img
                    class="<?php echo($save['filter'] == 'negative' ? 'photo_effects_active' : ''); ?>"
                    src="/foto/res/images/negative.jpg"/></a>
        <a href="?func=photo.effects&amp;effect=filter&amp;action=pixelate"><img
                    class="<?php echo($save['filter'] == 'pixelate' ? 'photo_effects_active' : ''); ?>"
                    src="/foto/res/images/pixelate.jpg"/></a>
    </div>

    <div class="photo_effects_title">Оттенок</div>

    <div class="photo_effects">
        <a href="?func=photo.effects&amp;effect=tint&amp;action=none">
            <i class="photo_effects <?php echo($save['tint'] == 'none' ? 'photo_effects_active' : ''); ?>"
               style="background: #fff;"></i>
        </a>
        <?php foreach ($tint AS $color) { ?>
            <a href="?func=photo.effects&amp;effect=tint&amp;action=<?php echo urlencode($color); ?>">
                <i class="photo_effects <?php echo($save['tint'] == $color ? 'photo_effects_active' : ''); ?>"
                   style="background: <?php echo $color; ?>;"></i>
            </a>
        <?php } ?>
    </div>

    <div class="photo_effects">
        <input class="submit" type="submit" value="Сохранить" name="ok"/>
        <a href="?">Отмена</a>
    </div>
</form>