<?php 

class Filter
{
    protected $filters; 
    protected $logs; 

    public function has($key, $function_to_check = false) {
        if ($function_to_check === false) {
            if (!empty($this->filters[$key])) {
                return true;
            }
            return false; 
        }
        
        if (!empty($this->filters[$key])) {
            foreach($this->filters[$key] AS $priority => $func) {
                if ($func['function'] == $function_to_check) {
                    return $priority; 
                }
            }
        }
        
        return false;
    }
    
    public function add($key, $callback, $priority, $accepted = 1) 
    {
        if (!isset($this->filters[$key][$priority])) {
            $this->filters[$key][$priority] = array(
                'function' => $callback, 
                'priority' => $priority, 
                'accepted' => $accepted, 
            );
            return true; 
        } else {
            $this->logs['errors'][] = array(
                'Фильтр {' . var_dump($callback) . '} с приоритетом {' . $priority . '} уже существует, это правило фильтра исключено!', 
            ); 
            echo 'Фильтр {' . $key . '} с приоритетом {' . $priority . '} уже существует, это правило фильтра исключено!<br />'; 
        }
        
        return false; 
    }
    
    public function remove($key, $callback, $priority, $accepted = 1) 
    {
        if (isset($this->filters[$key][$priority])) {
            unset($this->filters[$key][$priority]);
            return true;
        }
        
        return false; 
    }
    
    public function runFilter($key, $value) 
    {
		    if (isset($this->filters[$key])) {
  		        ksort($this->filters[$key]);
      			foreach($this->filters[$key] AS $p => $callback) {
                    if ($callback['accepted'] == 0) {
                        $content = call_user_func($callback['function'], $value);
                    } elseif ($callback['accepted'] == 1) {
                        $content = call_user_func($callback['function'], $value);
                    } else {
                        $args = $value;
                        if (isset($content)) {
                            $args[0] = $content; 
                        } 

                        $content = call_user_func_array($callback['function'], $args);
                    }
      			}
                
                return $content; 
    		}

        else {
            return $value;
        }
  	}
    
    public function runEvent($key, $value) 
    {
	    if (isset($this->filters[$key])) {
            ksort($this->filters[$key]);
        
  			foreach($this->filters[$key] AS $p => $callback) {
                if (is_callable($callback['function'])) {
                    if (is_array($value)) {
                        call_user_func_array($callback['function'], $value);
                    } else {
                        call_user_func($callback['function'], $value);
                    }
                }
  			}
		}
        
        else {
            return $value;
        }
  	}
}