<?php 

class Plugins
{
    private $file_headers = array(
    		'Name'        => 'Plugin Name',
    		'ThemeURI'    => 'Plugin URI',
    		'Description' => 'Description',
    		'Author'      => 'Author',
    		'AuthorURI'   => 'Author URI',
    		'Version'     => 'Version',
    		'Status'      => 'Status',
    		'Tags'        => 'Tags',
    		'TextDomain'  => 'Text Domain',
    		'DomainPath'  => 'Domain Path',
  	);

    public function init($optionType) 
    {
        $action = (!empty($_GET['action']) ? $_GET['action'] : ''); 
        $elid = (!empty($_GET['elid']) ? $_GET['elid'] : ''); 
        
        if ($action == 'activation') {
            ds_plugin_activate($elid);
            redirect('?module=' . ds_admin_get_page()); 
        }

        if ($action == 'deactivation') {
            ds_plugin_deactivate($elid);
            redirect('?module=' . ds_admin_get_page()); 
        }

        if ($action == 'remove') {
            if (!is_plugin_active( $elid )) {
                ds_plugin_remove($elid);
                redirect('?module=' . ds_admin_get_page()); 
            }
        }
    }
    
    public function getButtonRemove($btn, $post) 
    {
        $plugin = $post['slug'];

        if (is_plugin_active( $plugin )) {
            $btn['class'] = 'btn-sm btn-danger hidden-xs disabled'; 
        }
        
        return $btn; 
    }

    public function getButtonActivation($btn, $post) 
    {
        $plugin = $post['slug'];

        if (is_plugin_active($plugin)) {
            $link = array(
                'url' => '?module=plugins&action=deactivation&elid=%slug%', 
                'icon' => 'fa fa-stop', 
                'class' => 'btn-sm btn-secondary hidden-xs', 
                //'name' => __('Отключить'), 
            ); 
        }

        else {
            $link = array(
                'url' => '?module=plugins&action=activation&elid=%slug%', 
                'icon' => 'fa fa-play', 
                'class' => 'btn-sm btn-primary hidden-xs', 
                //'name' => __('Включить'), 
            ); 
        }
        
        return array_merge($btn, $link); 
    }

    public function listPlugins($optionType = '') 
    {
        $path = PATH_PLUGINS . DIRECTORY_SEPARATOR; 
        $opdirbase = opendir($path);
        
        $plugins = array(); 
        $sumHtml  = array(); 

        $registered = ds_plugins();

        if (!empty($registered)) {
            foreach($registered AS $key => $plugin) {
                if (!is_dir($path . $key)) {
                    ds_plugin_remove($key); 
                    unset($registered[$key]);
                }
            }
        }
        
        while ($filebase = readdir($opdirbase)) 
        {
            if (is_dir($path . $filebase) && !preg_match('/[\.]{1,2}/', $filebase)) {
              	if (is_file($path . $filebase . DIRECTORY_SEPARATOR . $filebase . '.php')) {
                    if (isset($registered[$filebase])) {
                        $plugins[] = $registered[$filebase];
                    } else {
                        $plugins[] = $this->getPluginInfo($path . $filebase, $filebase); 
                    }
              	}
            }
        }
        
        return $plugins; 
    }


    public function getPluginInfo($path, $file) 
    {
        $registered = ds_plugins();

        $info = array(); 
        if (is_file($path . DIRECTORY_SEPARATOR . $file . '.php')) {
            $plugin = file_get_contents($path . DIRECTORY_SEPARATOR . $file . '.php'); 
            
            foreach($this->file_headers AS $key => $value) {
                if (preg_match('|' . $value . ' ?: ?(.*)$|mi', $plugin, $matches)) {
                    $info[$key] = text($matches[1]);
                }
            }
        }

        $info['script'] = $file . DIRECTORY_SEPARATOR . $file . '.php'; 
        
        $info['slug'] = text($file);
        $info['Full'] = (!empty($info['Description']) ? $info['Description'] . '<br />' : '');
        
        $more = array(); 
        if (!empty($info['Version'])) {
            $more[] = __('Версия', 'admin') . ': ' . $info['Version'];
        }

        if (!empty($info['Status'])) {
            $more[] = __('Статус', 'admin') . ': ' . $info['Status'];
        }

        if (!empty($info['Author'])) {
            $more[] = __('Автор', 'admin') . ': ' . $info['Author'];
        }

        $more[] = __('Подробнее');
        
        $info['Full'] .= join(' | ', $more); 
        
        if (empty($info['Name'])) {
            $info['Name'] = substr($path, strrpos($path, '/') + 1); 
        }
        
        if (!isset($registered[$file])) {
            $info['active'] = 0; 
            ds_plugin_add($file, $info);
        }

        return $info;
    }
}