<?php 

$root_path_dir = dirname(dirname(dirname( __FILE__ ))); 

/**
* Загрузка конфигурационного файла системы
*/ 
if (is_file($root_path_dir . '/config.php')) {
    require($root_path_dir . '/config.php'); 
}

/**
* Константы
*/

// Время полуночь
define('FTIME', mktime(0, 0, 0));

// Текущая метка времени unix
define('TIME', time());


list($msec, $sec) = explode(chr(32), microtime()); 
define('MICROTIME', $sec + $msec);

define('ARRAY_A', true); 
define('ARRAY_N', false); 


/**
* Возвращает время генерации страницы 
* в момент вызова функции get_page_gen()
*/ 
function get_page_gen($per = 3) 
{
    $timestart = MICROTIME; 

    list($msec, $sec) = explode(chr(32), microtime()); 
    $timeend = $sec + $msec; 

    return number_format($timeend - $timestart, $per); 
}

// Корень сайта
if (!defined('H')) {
	define('H', $root_path_dir . '/'); 
}

if (!defined('ROOTPATH')) {
    define('ROOTPATH', $root_path_dir); 
}

if (!defined('PATH_CACHE')) {
    define('PATH_CACHE', $root_path_dir . '/sys/tmp/'); 
}

if (!defined('PATH_UPLOADS')) {
    define('PATH_UPLOADS', $root_path_dir . '/sys/uploads/'); 
}

if (!defined('PATH_PLUGINS')) {
    define('PATH_PLUGINS', $root_path_dir . '/sys/plugins/'); 
}

// отключаем показ ошибок
if (function_exists('error_reporting'))@error_reporting(0); 

// Ставим ограничение для выполнения скрипта на 60 сек
if (function_exists('set_time_limit'))@set_time_limit(60);

if (function_exists('ini_set')) {
    ini_set('display_errors', false); // отключаем показ ошибок
    ini_set('register_globals', false); // вырубаем глобальные переменные
    ini_set('session.use_cookies', true); // используем куки для сессий
    ini_set('session.use_trans_sid', true); // используем url для передачи сессий
    ini_set('arg_separator.output', "&amp;"); // разделитель переменных в url (для соответствия с xml)
}

// принудительно вырубаем глобальные переменные
if (ini_get('register_globals')) {
    $allowed = array('_ENV' => 1, '_COOKIE' => 1, '_FILES' => 1, '_GET' => 1, '_POST' => 1, '_SERVER' => 1, '_REQUEST' => 1, 'GLOBALS' => 1);
    foreach ($GLOBALS as $key => $value) {
        if (!isset($allowed[$key])) {
            unset($GLOBALS[$key]);
        }
    }
}

// время запуска скрипта
list($msec, $sec) = explode(chr(32), microtime()); 
$conf['headtime'] = $sec + $msec;
$time = time();

/**
* Загрузка классов системы
*/
require(ROOTPATH.'/sys/inc/classes/autoload.php');

/**
* Инициализация Хуков
*/

$filter = new Filter(); 
Registry::set('Filter', $filter); 

$tools = new Tools();
Registry::set('Tools', $tools); 

// Загрузка функций
require H.'sys/inc/functions.php';

// Установка событий по умолчанию 
require H.'sys/inc/events.php';

if (isset($_POST['msg'])) {
    $_POST['msg'] = emoji_to_code($_POST['msg']);
}

$phpvervion = explode('.', phpversion());
$conf['phpversion'] = $phpvervion[0];

$upload_max_filesize = ini_get('upload_max_filesize');

if (preg_match('#([0-9]*)([a-z]*)#i', $upload_max_filesize, $varrs)) {
    if ($varrs[2] == 'M')$upload_max_filesize = $varrs[1]*1048576;
    elseif ($varrs[2] == 'K')$upload_max_filesize = $varrs[1]*1024;
    elseif ($varrs[2] == 'G')$upload_max_filesize = $varrs[1]*1024*1048576;
}

session_name('SESS');
session_start();

$sess = addslashes(session_id());
if (!preg_match('#[A-z0-9]{32}#i', $sess)) {
	$sess = md5(mt_rand(1111, 999999));
}

do_event('ds_session_init'); 

$passgen = passgen();

/**
* Настройки системы основные 
*/ 

/*
$set = array(); // массив с настройками
$set_default = array();
$set_dinamic = array();
$set_replace = array();

// загрузка настроек по умолчанию. Позволяет исключить отсутствие неопределенных переменных
$default = @parse_ini_file(H.'sys/dat/default.ini',true);
$set_default = @$default['DEFAULT'];
$set_replace = @$default['REPLACE'];

$ds_file_settings = use_filters('ds_settings_file', H.'sys/dat/settings_6.2.dat'); 

if ($fset = @file_get_contents(H.'sys/dat/settings_6.2.dat')) {
    $set_dinamic = unserialize($fset);
} elseif (file_exists(H.'install/index.php')) {
  	header("Location: /install/");
  	exit;
}

$set = use_filters('ds_settings_filter', array_merge($set_default, $set_dinamic, $set_replace));
*/

$set = get_settings();

// Событие после инициализации настроек системы
do_event('ds_settings_init'); 

if ($set['show_err_php']) {
  	error_reporting(E_ALL); 
  	ini_set('display_errors', true); 
}

/**
* База данных подключение
*/
db::connect( DB_HOST, DB_USER, DB_PASSWORD, DB_NAME ); 

if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

// Событие при успешном подключении к базе данных
do_event('ds_mysql_init'); 


/**
* Загрузка плагинов 
*/ 
$plugins = ds_plugins();  
Registry::set('ds_plugins', $plugins); 

foreach($plugins AS $plugin) {
    if (is_plugin_active($plugin['slug']) === true) {
        $plugin_path = PATH_PLUGINS . DIRECTORY_SEPARATOR; 
        if (is_file($plugin_path . $plugin['script'])) {
            require $plugin_path . $plugin['script']; 
            define('plugin_' . $plugin['slug'] . '_loaded', 1); 
        }
    }
}

// Событие после загрузки всех плагинов
do_event('ds_plugins_loaded'); 

// Авторизация пользователя
if (isset($_SESSION['id_user'])) {
    $user_id = use_filters('ds_session_user', $_SESSION['id_user']); 
    $user = get_user($user_id);
    $user['type_input'] = 'session';
} 

elseif (!empty($_COOKIE['id_user']) && !empty($_COOKIE['pass'])) {
    $user_auth = use_filters('ds_auth_data', array(
        'key' => 'id', 
        'id' => $_COOKIE['id_user'], 
        'pass' => cookie_decrypt($_COOKIE['pass']), 
    )); 

    if (is_auth_user($user_auth['id'], $user_auth['pass'], $user_auth['key'])) {
        $user = get_user($user_auth['id']);
        $_SESSION['id_user'] = $user['id']; 
        $user['type_input'] = 'cookie';
    }
}

// Событие что пользователь авторизован
if (isset($user['id'])) {
    do_event('ds_user_init'); 
}

if (isset($_SERVER["HTTP_USER_AGENT"]) && preg_match('#up-browser|blackberry|windows ce|symbian|palm|nokia#i', $_SERVER["HTTP_USER_AGENT"]))
$webbrowser = false;

elseif (isset($_SERVER["HTTP_USER_AGENT"]) && (preg_match('#windows#i', $_SERVER["HTTP_USER_AGENT"]) || 
        preg_match('#linux#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#bsd#i', $_SERVER["HTTP_USER_AGENT"]) || 
        preg_match('#x11#i', $_SERVER["HTTP_USER_AGENT"]) || preg_match('#unix#i', $_SERVER["HTTP_USER_AGENT"]) || 
        preg_match('#macos#i', $_SERVER["HTTP_USER_AGENT"]) ||preg_match('#macintosh#i', $_SERVER["HTTP_USER_AGENT"])))
$webbrowser = true;

else 
$webbrowser = false;
$set['web'] = false;


$ipa = false;
if(isset($_SERVER['HTTP_X_FORWARDED_FOR']) && $_SERVER['HTTP_X_FORWARDED_FOR']!='127.0.0.1' && preg_match("#^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$#",$_SERVER['HTTP_X_FORWARDED_FOR']))
{
	$ip2['xff'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
	$ipa[] = $_SERVER['HTTP_X_FORWARDED_FOR'];
}
if(isset($_SERVER['HTTP_CLIENT_IP']) && $_SERVER['HTTP_CLIENT_IP']!='127.0.0.1' && preg_match("#^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$#",$_SERVER['HTTP_CLIENT_IP']))
{
	$ip2['cl'] = $_SERVER['HTTP_CLIENT_IP'];
	$ipa[] = $_SERVER['HTTP_CLIENT_IP'];
}
if(isset($_SERVER['REMOTE_ADDR']) && preg_match("#^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$#",$_SERVER['REMOTE_ADDR']))
{
	$ip2['add'] = $_SERVER['REMOTE_ADDR'];
	$ipa[] = $_SERVER['REMOTE_ADDR'];
}

$ip = $ipa[0];

$iplong = ip2long($ip);

if (isset($_SERVER['HTTP_USER_AGENT']))
{
	$ua = $_SERVER['HTTP_USER_AGENT'];
	$ua = strtok($ua, '/');
	$ua = strtok($ua, '('); // оставляем только то, что до скобки
	$ua = preg_replace('#[^a-z_\./ 0-9\-]#iu', null, $ua); // вырезаем все "левые" символы

	// Опера мини тоже посылает данные о телефоне :)
	if (isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA']) && preg_match('#Opera#i',$ua))
	{
		$ua_om = $_SERVER['HTTP_X_OPERAMINI_PHONE_UA'];
		$ua_om = strtok($ua_om, '/');
		$ua_om = strtok($ua_om, '(');
		$ua_om = preg_replace('#[^a-z_\. 0-9\-]#iu', null, $ua_om);
		$ua = 'Opera Mini ('.$ua_om.')';
	}
}
else $ua = 'Нет данных';

$ftime = mktime(0, 0, 0);
$num = 0; 

require(ROOTPATH.'/sys/inc/user.php');

do_event('ds_init'); 