<?php 

/**
* Возвращает путь до папки с плагином
* @return string
*/ 
function ds_plugin_directory_path($type) {
    if (is_dir(PATH_PLUGINS . DIRECTORY_SEPARATOR . $type)) {
        return PATH_PLUGINS . DIRECTORY_SEPARATOR . $type; 
    }
}

/**
* Возвращает массив с плагинами
* @return array
*/ 
function ds_plugins() 
{
  	if ($plugins = ds_get('ds_plugins')) {
  		  return $plugins;
  	}

  	$json = get_option( 'ds_plugins'); 
  	if ($json) {
  		  $plugins = json_decode($json, 1);
  	}

  	return is_array($plugins) ? $plugins : array(); 
}


/**
* Функция активирует плагин
* @return bolean
*/ 
function ds_plugin_activate($plug) 
{
    $plugin_path = ds_plugin_directory_path($plug) . '/' . $plug . '.php'; 

    if (!defined('plugin_' . $plug . '_loaded') && is_file($plugin_path)) {
        require $plugin_path; 
    }

    do_event('ds_plugin_pre_activation', $plug);
    do_event('ds_plugin_' . $plug . '_pre_activation', $plug);

  	$plugins = ds_plugins();

  	if (isset($plugins[$plug])) {
    		$plugins[$plug]['active'] = '1'; 
    		update_option('ds_plugins', json_encode($plugins), 'plugins'); 

        do_event('ds_plugin_activation', $plug);
        do_event('ds_plugin_' . $plug . '_activation', $plug);
    		return true;
  	}

  	return false; 
}


/**
* Функция деактивирует плагин
* @return bolean
*/ 
function ds_plugin_deactivate($plug) 
{
    do_event('ds_plugin_pre_deactivation', $plug);
    do_event('ds_plugin_' . $plug . '_pre_deactivation', $plug);

  	$plugins = ds_plugins();

  	if (isset($plugins[$plug])) {
    		$plugins[$plug]['active'] = '0'; 
    		update_option('ds_plugins', json_encode($plugins), 'plugins'); 

        do_event('ds_plugin_deactivation', $plug);
        do_event('ds_plugin_' . $plug . '_deactivation', $plug);
    
    		return true;
  	}

  	return false; 
}

/**
* Функция добавляет плагин в список плагинов
* @return bolean
*/ 
function ds_plugin_add($plug, $info) 
{
  	$plugins = ds_plugins();
  	if (!isset($plugins[$plug])) {
    		$plugins[$plug] = $info; 
    		$plugins[$plug]['active'] = '0'; 
    		update_option('ds_plugins', json_encode($plugins), 'plugins'); 
    		return true;
  	}

  	return false; 
}

/**
* Функция удаляет плагин из системы
* @return bolean
*/ 
function ds_plugin_remove($plug) 
{
  	$plugins = ds_plugins();
  	if (isset($plugins[$plug])) {

        if (is_dir(PATH_PLUGINS . $plug)) {
            delete_dir(PATH_PLUGINS . $plug); 
        }

    		unset($plugins[$plug]); 
    		update_option('ds_plugins', json_encode($plugins), 'plugins'); 
    		return true;
  	}

  	return false; 
}

/**
* Проверка активен ли плагин
* @return bolean
*/ 
function is_plugin_active($plug) 
{
  	$plugins = ds_plugins();

  	if (!empty($plugins[$plug]) && $plugins[$plug]['active'] == '1') {
  		  return true;
  	}
  	
  	return false; 
}