<?php 

/**
* Является ли страница главной
*/
function is_home() 
{
	if ($_SERVER['REQUEST_URI'] == '/' || $_SERVER['REQUEST_URI'] == '/index.php') {
		return true; 
	}
	return false; 
}

function ds_site_url() 
{
	$http = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? 'https' : 'http'); 
	return $http.'://'.$_SERVER['HTTP_HOST']; 
}

function uploads_uri() 
{
    return ds_site_url() . '/sys/uploads'; 
}

/**
* Ищет ссылки в тексте и возвращает массивом
* @return array
*/ 
function ds_export_links( $text ) 
{
	preg_match_all(
		"#([\"']?)("
			. '(?:([\w-]+:)?//?)'
			. '[^\s()<>]+'
			. '[.]'
			. '(?:'
				. '\([\w\d]+\)|'
				. '(?:'
					. "[^`!()\[\]{};:'\".,<>«»“”‘’\s]|"
					. '(?:[:]\d+)?/?'
				. ')+'
			. ')'
		. ")\\1#",
		$text,
		$links
	);

	$links = array_unique( array_map( 'html_entity_decode', $links[2] ) );

	return array_values( $links );
}

function ds_rewrite_rule($regexp, $callback, $params = '') 
{
	global $DS_REWRITE_RULES; 

	$DS_REWRITE_RULES[] = use_filters('ds_rewrite_rule', array(
		'regex' => $regexp, 
		'callback' => $callback, 
		'params' => $params, 
	)); 
}

function ds_rewrite_rule_start() 
{
	global $DS_REWRITE_RULES, $user, $set, $ftime, $time, $conf, $webbrowser, $num; 

	$request = (!empty($_GET['route']) ? $_GET['route'] : 'index.php'); 

	foreach($DS_REWRITE_RULES AS $key => $rules) {
		if (preg_match('/^' . $rules['regex'] . '$/m', $request, $matches)) {
			foreach($matches AS $key => $value) {
				$rules['params'] = str_replace('$'.$key, $value, $rules['params']); 

				// Замена в пути файла или callback 
				if (is_string($rules['callback']) && strpos($rules['callback'], '$') !== false) {
					$rules['callback'] = str_replace('$'.$key, $value, $rules['callback']); 
				}
			}

			if (is_callable($rules['callback'])) {
				add_event('pre_include_file', $rules['callback']); 
				do_event('pre_include_file'); 
			}

			else {
				if (is_file($rules['callback'])) {
					require $rules['callback']; 
					exit; 
				}				
			}
		}
	}

	do_event('page_not_found'); 

	header("HTTP/1.0 404 Not Found");
	exit;
}


// Хук после инициализации функций rewrite rules 
do_event('functions_rewrite_loaded'); 