<?php 

/**
* Алиасы класса Registry
* @return object | string | array
*/

function ds_get($key, $default = NULL) {
    if (isset($key)) {
        $get = Registry::get($key); 

        if ($get === NULL && $default !== NULL) {
            return $default;
        }
        return $get; 
    }
}

/**
* Регистрирует глобальную переменную
* @return bolean true
*/
function ds_set($key, $var) {
    return Registry::set($key, $var); 
}

/**
* Возвращает все глобальные данные
* @return array
*/
function ds_getAll() {
    return Registry::getAll($key); 
}

function get_settings($key = false, $default = '') 
{
    $set = array();
    $set_default = array();
    $set_dinamic = array();
    $set_replace = array();

    $ini = parse_ini_file( ROOTPATH.'/sys/upgrade/settings.ini', true );

    if (is_array($ini['DEFAULT'])) {
        $set_default = $ini['DEFAULT'];
    }
    
    if (is_array($ini['REPLACE'])) {
        $set_replace = $ini['REPLACE'];
    }
    
    $set_dinamic = get_options();

    $set = use_filters('ds_settings_filter', array_merge($set_default, $set_dinamic, $set_replace));

    if ($key === false) {
        return $set; 
    }
	
    elseif (isset($set[$key])) {
		return $set[$key]; 
	}

	return $default; 
}




function file_add_cache($cacheFile, $array) {
    $cacheFile = PATH_CACHE . '/' . $cacheFile . '.cache';

    if (is_file($cacheFile)) {
        unlink($cacheFile);
    } 

    file_put_contents($cacheFile, json_encode($array));
}

function file_get_cache($cacheFile) {
    $cacheFile = PATH_CACHE . '/' . $cacheFile . '.cache';

    if (is_file($cacheFile)) {
        $cache = json_decode(file_get_contents($cacheFile), 1); 
        return $cache;
    }

    return false; 
}

function file_delete_cache($cacheFile) {
    $cacheFile = PATH_CACHE . '/' . $cacheFile . '.cache';
    if (is_file($cacheFile)) {
        unlink($cacheFile);
    } 
}


function get_options($type = 'autoload') 
{
    $options = ds_get('ds_options');
    if (!empty($options)) {
        return $options; 
    }

    $res = db::select("SELECT * FROM `options` WHERE `type` = '" . $type . "'"); 

    $options = array(); 
    foreach($res AS $key => $option) {
        $options[$option['name']] = $option['value']; 
    }

    return $options; 
}

function get_option($key, $default = NULL) 
{
    $options = ds_get('ds_options');

    if (!empty($options)) {
        if (!isset($options[$key])) {
            return $default;
        }
        return $options[$key]; 
    }

    $cache = file_get_cache('options.cache'); 
    if ($cache) {
        if ($cache[$key]) {
            return $cache[$key]; 
        }
    }
    
    $res = db::fetch("SELECT * FROM `options` WHERE `name` = '" . my_esc($key) . "' LIMIT 1"); 

    if ($res) {
        return $res['value']; 
    }
    
    return $default; 
}

function update_option($key, $value, $type = '') 
{ 
    // Удаляем кеш опций
    file_delete_cache('options'); 

    $option = db::fetch("SELECT * FROM `options` WHERE `name` = '" . $key . "' LIMIT 1"); 

    if (isset($option['id'])) {
        $update = array(
            'value' => my_esc($value), 
        ); 
        db::update('options', $update, array('name' => $key)); 
    }
    
    else {
       db::query("INSERT INTO `options` (`name`, `value`, `type`) VALUES ('$key', '$value', '$type')");
    }
}

function ds_options_load() 
{
    $cache = file_get_cache('options'); 

    if (empty($cache)) {
        $options = db::select("SELECT * FROM `options` WHERE type = 'autoload'", ARRAY_A);

        $cache = array(); 
        foreach($options AS $option) {
            $cache[$option['name']] = $option['value']; 
        }
        file_add_cache('options', $cache);
        ds_get('ds_options', $cache); 
    }

    ds_set('ds_options', $cache);
}



function ds_readdir_files_list($dir, $ds_files_recursive = array()) 
{
    $opdirbase = opendir($dir);
    while ($filebase = readdir($opdirbase)) {
        if ($filebase == '..' || $filebase == '.') continue; 

        if (is_file($dir . '/' . $filebase)) {
            $ds_files_recursive[] = $dir . '/' . $filebase;
        }

        elseif (is_dir($dir . '/' . $filebase)) {
            $ds_files_recursive = array_merge_recursive($ds_files_recursive, ds_readdir_files_list($dir . '/' . $filebase)); 
        }
    }

    return $ds_files_recursive; 
}

function ds_readdir_dir_list($dir, $ds_directory_recursive = array()) 
{
    $opdirbase = opendir($dir);
    while ($filebase = readdir($opdirbase)) {
        if ($filebase == '..' || $filebase == '.') continue; 

        if (is_dir($dir . '/' . $filebase)) {
            $ds_directory_recursive[] = $dir . '/' . $filebase;
            $ds_directory_recursive = array_merge_recursive($ds_directory_recursive, ds_readdir_dir_list($dir . '/' . $filebase)); 
        }
    }

    return $ds_directory_recursive; 
}

function ds_check_installed() 
{
    $install = true; 
    if (!is_file(ROOTPATH . '/config.php')) {
        header('Location: ' . ds_site_url() . '/adm_panel/install.php'); 
        exit;
    }
}