<?php 

/**
* header.php для шаблонов сайта
* Хук событие: {init_head_theme}
*/
function get_header() 
{
    add_event('init_head_theme', 'ds_theme_styles_init'); 
    do_event('init_head_theme');

    global $err, $set; 
    ds_set('ds_errors', $err); 

	if (is_file(get_theme_directory().'/header.php')) {
		require(get_theme_directory().'/header.php'); 
	}
}

/**
* footer.php для шаблонов сайта
* Хук событие: {init_foot_theme}
*/
function get_footer() 
{
    do_event('init_foot_theme'); 

	if (is_file(get_theme_directory().'/footer.php')) {
		require(get_theme_directory().'/footer.php'); 
	}
}

/**
* Путь до папки с темой
*/ 
function get_theme_directory() 
{
	global $set; 
	return (ROOTPATH . '/style/themes/' . $set['set_them']); 
}

/**
* Путь до папки с темами
*/ 
function get_themes_directory() 
{
	return (ROOTPATH . '/style/themes'); 
}

/**
* URL адрес до папки с темой
*/ 
function get_theme_uri() 
{
	global $set; 
	return ds_site_url() . '/style/themes/' . $set['set_them']; 
}

/**
* Вывод сообщений в теме шаблона
*/ 
function the_messages() 
{
	do_event('pre_output_messages');

	if (isset($_SESSION['message'])) {
		do_event('the_messages_output');
		echo use_filters('the_message_filter', '<div class="msg">' . $_SESSION['message'] . '</div>'); 
		$_SESSION['message'] = NULL; 
	}
}

/**
* Вывод сообщений ошибок в теме шаблона
*/ 
function the_errors() 
{
	do_event('pre_output_errors');
	$errors = get_the_errors(); 

	foreach($errors AS $error) {
		echo use_filters('the_error_filter', '<div class="err">' . $error . '</div>'); 
	}

    do_event('the_errors_output');
}

function get_the_errors() 
{
    $err = ds_get('ds_errors', array()); 

	if (!empty($err)) {
		if (is_array($err)) {
			return $err; 
		} else {
			return array($err); 
		}
	}

    return $err; 
}

function ds_head() 
{
    do_event('init_head'); 
    ds_theme_styles_html();
    ds_theme_scripts_html();
}

function ds_foot() 
{
    do_event('init_foot'); 
}

function ds_themes() 
{
    $path = get_themes_directory(); 
    $opdirbase = opendir($path);

    $templates = array(); 
    while ($filebase = readdir($opdirbase)) 
    {
        if (is_dir($path . $filebase) && !preg_match('/[\.]{1,2}/', $filebase)) {
            $templates[$filebase] = $filebase; 
        }
    }

    return $templates;
}

/**
* Функция возвращает конечный заголовок страницы
* @return string 
*/
function ds_get_document_title() {
    $title = Registry::get('document_title'); 

    global $set; 

    if (isset($set['title'])) {
        $title = $set['title']; 
    } elseif (empty($title)) {
        $title = get_settings('title');
    }
    
    return use_filters('ds_get_document_title', $title);
}

/**
* Функция выводит конечный заголовок страницы
* @display string 
*/
function ds_document_title() {
    echo use_filters('ds_document_title', ds_get_document_title());
}

function ds_title() 
{
    do_event('ds_output_title'); 
}

/**
* Регистрация классов для тега body
* Принимает аргументы string | array
*/
function add_body_class($class) {
    $classes = ds_get('ds_body_classes', array()); 
    
    if (is_array($class)) {
        foreach($class AS $key => $value) {
            if (!isset($classes[$value])) {
                $classes[] = $value; 
            }
        }
    }
    
    elseif (!isset($classes[$class])) {
        $classes[] = $class; 
    }
    
    ds_set('ds_body_classes', $classes); 
}

/**
* Удаление классов у тега body
* Принимает аргументы string | array
*/
function remove_body_class($class) {
    $classes = ds_get('ds_body_classes', array()); 
    
    if (is_array($class)) {
        foreach($class AS $key => $value) {
            if ($search = array_search($value)) {
                unset($classes[$search]); 
            }
        }
    }
    
    else { 
        if ($search = array_search($class)) {
            unset($classes[$search]); 
        }
    }
    
    ds_set('ds_body_classes', $classes); 
}

/**
* Возвращает все зарегистрированные классы body
* @return string
*/
function get_body_class() 
{ 
    $classes = ds_get('ds_body_classes', array()); 
    
    // если авторизован
    if (is_user()) {
        $classes[] = 'logged-in';
    }
    
    // Главная страница
    if ($_SERVER['REQUEST_URI'] == '/' || $_SERVER['REQUEST_URI'] == '/index.php') {
        $classes[] = 'home';
    }
    
    return use_filters('ds_body_class', $classes); 
}

/**
* Выводит все зарегистрированные классы body
* @display string
*/
function body_class() 
{
    echo 'class="' . join(' ', get_body_class()) . '"'; 
}

/**
* Инициализация css файлов для шаблона темы
*/
function ds_theme_styles_init() 
{
    if (is_file(get_theme_directory() . '/style.css')) {
        ds_theme_style_add(use_filters('ds_base_default_theme_style', get_theme_uri() . '/style.css'), 'style', '', 'all'); 
    }
}

/**
* Функция регистрирует файл стилей
* @return bolean
*/

function ds_theme_style_add($url = '', $uniquie = 'style', $version = '', $media = 'all') {
    $styles = Registry::get('enqueue_style'); 
    if (empty($styles)) {
        $styles = array();
    }
    
    if (!isset($styles[$uniquie])) {
        $styles[$uniquie] = array(
            'url' => $url, 
            'version' => $version, 
            'uniquie' => $uniquie, 
            'media' => $media, 
        );
        Registry::set('enqueue_style', $styles); 
        return true; 
    }
    
    return false; 
}

/**
* Удаляет все объявленные стили
*/
function ds_theme_styles_delete_all() {
    Registry::set('enqueue_style', array());
}

/**
* Функция удаляет файл стилей из вывода
* @return bolean
*/
function ds_theme_style_delete($uniquie = '') {
    $styles = Registry::get('enqueue_style'); 
    
    if (isset($styles[$uniquie])) {
        unset($styles[$uniquie]);
        if (empty($styles)) {
            $styles = array(); 
        }
        Registry::set('enqueue_style', $styles); 
        return true; 
    }
    
    return false; 
}

/**
* Вернет массив указанного стиля
* @return array 
*/
function ds_theme_get_style($uniquie = '') {
    $styles = Registry::get('enqueue_style'); 
    if (isset($styles[$uniquie])) {
        return $styles[$uniquie];
    }
    return array(); 
}

/**
* Вернет URI указанного стиля
* @return string 
*/
function ds_theme_get_style_uri($uniquie = '') {
    if ($style = ds_theme_get_style($uniquie)) {
        return $style['url']; 
    }
}

/**
* Выводит URI указанного стиля
* @display string 
*/
function ds_theme_style_uri($uniquie = '') {
    echo ds_theme_get_style_uri($uniquie); 
}

/**
* Вернет html код с указанным стилем
* @return string 
*/
function ds_theme_get_style_html($uniquie = '') {
    if ($style = ds_theme_get_style($uniquie)) {
        $css  = '<link rel="stylesheet"';
        $css .= ' id="' . $uniquie . '"';
        $css .= ' type="text/css"';
        $css .= ' href="' . $style['url'] . ($style['version'] ? '?version=' . $style['version'] : '') . '"';
        $css .= ' media="' . $style['media'] . '">'; 
        
        return $css; 
    }
}

/**
* Выводит html код с указанным стилем
* @display html 
*/
function ds_theme_style_html($uniquie = '') {
    echo ds_theme_get_style_html($uniquie); 
}

/**
* Вернет массив всех объявленных стилей
* @return array 
*/
function ds_theme_get_styles($uniquie = false) {
    $styles = Registry::get('enqueue_style'); 
    if ($styles) {
        $array = array(); 
        foreach($styles AS $key => $value) {
            if ($uniquie === true) {
                $array[$key] = $value; 
            } else {
                $array[] = $value; 
            }
        }
        return $array; 
    }
    return array(); 
}

/**
* Вернет html код всех объявленных стилей
* @return string 
*/
function ds_theme_get_styles_html() {
    $styles = Registry::get('enqueue_style'); 

    if ($styles) {
        $array = array(); 
        foreach($styles AS $key => $value) {
            $array[] = ds_theme_get_style_html($key); 
        }
        return implode("\n", $array) . "\n"; 
    }
}

/**
* Выводит html код всех объявленных стилей
* @display html 
*/
function ds_theme_styles_html() {
    echo ds_theme_get_styles_html();
}


/**
* Функция регистрирует файл javascript
* @return bolean
*/

function ds_theme_script_add($url = '', $uniquie = 'script', $version = '') {
    $scripts = ds_get('enqueue_script'); 
    if (empty($scripts)) {
        $scripts = array();
    }
    
    if (!isset($scripts[$uniquie])) {
        $scripts[$uniquie] = array(
            'url' => $url, 
            'version' => $version, 
            'uniquie' => $uniquie, 
        );
        ds_set('enqueue_script', $scripts); 
        return true; 
    }
    
    return false; 
}

/**
* Удаляет все объявленные скрипты
*/
function ds_theme_scripts_delete_all() {
    ds_set('enqueue_script', array());
}

/**
* Функция удаляет файл скрипта из вывода
* @return bolean
*/
function ds_theme_script_delete($uniquie = '') {
    $scripts = ds_get('enqueue_script'); 
    
    if (isset($scripts[$uniquie])) {
        unset($scripts[$uniquie]);
        if (empty($scripts)) {
            $scripts = array(); 
        }
        ds_set('enqueue_script', $scripts); 
        return true; 
    }
    
    return false; 
}

/**
* Вернет массив указанного javascript
* @return array 
*/
function ds_theme_get_script($uniquie = '') {
    $scripts = ds_get('enqueue_script'); 
    if (isset($scripts[$uniquie])) {
        return $scripts[$uniquie];
    }
    return array(); 
}

/**
* Вернет URI указанного javascript
* @return string 
*/
function ds_theme_get_script_uri($uniquie = '') {
    if ($script = ds_theme_get_script($uniquie)) {
        return $script['url']; 
    }
}

/**
* Выводит URI указанного javascript
* @display string 
*/
function ds_theme_script_uri($uniquie = '') {
    echo ds_theme_get_script_uri($uniquie); 
}

/**
* Вернет html код с указанным javascript
* @return string 
*/
function ds_theme_get_script_html($uniquie = '') {
    if ($script = ds_theme_get_script($uniquie)) {
        $javascript  = "\n<script ";
        $javascript .= 'id="' . $uniquie . '" ';
        $javascript .= 'type="text/javascript" ';
        $javascript .= 'src="' . $script['url'] . ($script['version'] ? '?version=' . $script['version'] : '') . '"';
        $javascript .= '></script>'; 
        
        return $javascript; 
    }
}

/**
* Выводит html код с указанным javascript
* @display html 
*/
function ds_theme_script_html($uniquie = '') {
    echo ds_theme_get_script_html($uniquie); 
}

/**
* Вернет массив всех объявленных javascript
* @return array 
*/
function ds_theme_get_scripts($uniquie = false) {
    $scripts = ds_get('enqueue_script'); 
    if ($scripts) {
        $array = array(); 
        foreach($scripts AS $key => $value) {
            if ($uniquie === true) {
                $array[$key] = $value; 
            } else {
                $array[] = $value; 
            }
        }
        return $array; 
    }
    return array(); 
}

/**
* Вернет html код всех объявленных javascript
* @return string 
*/
function ds_theme_get_scripts_html() {
    $scripts = ds_get('enqueue_script'); 

    if ($scripts) {
        $array = array(); 
        foreach($scripts AS $key => $value) {
            $array[] = ds_theme_get_script_html($key); 
        }
        return implode("\n", $array) . "\n"; 
    }
}

/**
* Выводит html код всех объявленных javascript
* @display html 
*/
function ds_theme_scripts_html() {
    echo ds_theme_get_scripts_html();
}