<?php 

/**
* Проверяет наличие пользователя по логину и паролю 
* Кеширует данные для дальнейшего их использования
* @return bolean 
*/ 

function is_auth_user($value, $password, $key = 'id') 
{
	global $ds_users_cache; 

	if (!$value || !$password) {
		return false; 
	}

	$password = shif($password); 
	$user = db::fetch("SELECT * FROM `user` WHERE `$key` = '$value' AND `pass` = '$password' LIMIT 1", ARRAY_A);

	if (isset($user['id'])) {
		if (!isset($ds_users_cache[$user['group_access']])) {
			$group_access = get_group_access($user['group_access']);

			$user['level'] = $group_access['level'];
            $user['group_name'] = $group_access['group_name'];

			$ds_users_cache[$user['id']] = use_filters('ds_users_cache_add', $user); 
		}
		return true; 
	}
	return false; 
}

/**
* Получает данные пользователя
* $user_id ID пользователя
* @return array 
*/

function get_user( $user_id = 0 )
{
    global $ds_users_cache;

    if ( $user_id == 0 ) {
        $ank2['id']         = 0;
        $ank2['nick']       = 'Система';
        $ank2['level']      = 999;
        $ank2['pol']        = 1;
        $ank2['group_name'] = 'Системный робот';
        $ank2['ank_o_sebe'] = 'Создан для уведомлений';
        return $ank2;
    } else {
        $user_id = (int) $user_id;

        if (!isset($ds_users_cache[$user_id])) {
            $ds_users_cache[$user_id] = db::fetch("SELECT * FROM `user` WHERE `id` = '$user_id' LIMIT 1", ARRAY_A);

            if (isset($ds_users_cache[$user_id]['id'])) {
                $group_access = get_group_access($ds_users_cache[$user_id]['group_access']);

                if ( $group_access['group_name'] == null ) {
                    $ds_users_cache[$user_id]['level']      = 0;
                    $ds_users_cache[$user_id]['group_name'] = 'Пользователь';
                } else {
                    $ds_users_cache[$user_id]['level']      = $group_access['level'];
                    $ds_users_cache[$user_id]['group_name'] = $group_access['group_name'];
                }
            } else {
                $ds_users_cache[$user_id] = false;
            }
        }
        return $ds_users_cache[$user_id];
    }
}

/**
* Получает и кеширует груггу пользователя
* $group_id ID группы
* @return array 
*/ 
function get_group_access($group_id) 
{
	global $ds_group_accesses; 

	if (!isset($ds_group_accesses[$group_id])) {
    	$group_access = db::fetch("SELECT `level`, `name` AS `group_name` 
	    												FROM `user_group` 
	    												WHERE `id` = '" . (int) $group_id . "' LIMIT 1", ARRAY_A);

    	$ds_group_accesses[$group_id] = $group_access;
	}

	return $ds_group_accesses[$group_id]; 
}

/**
* Генератор пароля
* $k_simb колличество символов
* @return string
*/ 
function passgen($k_simb = 8, $types = 3) 
{
	$password = '';	
	$small = 'abcdefghijkmnpqrstuvwxyz';	
	$large = 'ABCDEFGHIJKLMNPQRSTUVWXYZ';	
	$numbers = '1234567890';	
	
	mt_srand((double)microtime()*1000000);	 
	
	for ($i = 0; $i < $k_simb; $i++) 
	{		
		$type = mt_rand(1,min($types,3));	
			
		switch ($type) 
		{		
			case 3:		
			$password .= $large[mt_rand(0, strlen($large) - 1)];			
			break;			
			case 2:			
			$password .= $small[mt_rand(0, strlen($small) - 1)];			
			break;			
			case 1:			
			$password .= $numbers[mt_rand(0,9)];			
			break;		
		}	
	}	

	return $password;
}

/**
* Обновляет информацию о пользователе
* Хук фильтр: {update_user_information}
*/ 

function update_user_information() 
{
	global $user, $ds_user_update; 

	$ds_user_update['date_last'] = time(); 
	$ds_user_update = use_filters('update_user_information', $ds_user_update); 

	if (isset($user['id'])) {
		db::update('user', $ds_user_update, array(array(
			'field' => 'id', 
			'value' => $user['id'], 
		))); 
	}
}


/**
* Добавляет данные о пользователе
*/ 
function add_user_update($key, $value) 
{
	global $ds_user_update; 
	$ds_user_update[$key] = $value; 
}

function is_user() {
	global $user; 
	if (isset($user['id'])) {
		return true; 
	}
	return false; 
}


/**
* Счетчики пользователя
* Хук фильтр: {ds_user_counters}
*/ 
function get_user_counters() 
{
	global $user; 

	$counter = array(); 
	$counter['mail'] = array(
		'title' => __('Сообщения'), 
		'count' => db::count("SELECT COUNT(`mail`.`id`) FROM `mail`
			 LEFT JOIN `users_konts` ON `mail`.`id_user` = `users_konts`.`id_kont` AND `users_konts`.`id_user` = '$user[id]'
			 WHERE `mail`.`id_kont` = '$user[id]' AND (`users_konts`.`type` IS NULL OR `users_konts`.`type` = 'common' OR `users_konts`.`type` = 'favorite') AND `mail`.`read` = '0'"), 
	); 
	$counter['tape'] = array(
		'title' => __('Лента'), 
		'count' => db::count("SELECT COUNT(`read`) FROM `tape` WHERE `id_user` = '$user[id]' AND `read` = '0'"), 
	); 
	$counter['discussions'] = array(
		'title' => __('Обсуждения'), 
		'count' => db::count("SELECT COUNT(`count`) FROM `discussions` WHERE `id_user` = '$user[id]' AND `count` > '0'"), 
	); 
	$counter['notification'] = array(
		'title' => __('Уведомления'), 
		'count' => db::count("SELECT COUNT(`read`) FROM `notification` WHERE `id_user` = '$user[id]' AND `read` = '0'"), 
	); 
	$counter['friends'] = array(
		'title' => __('Друзья'), 
		'count' => db::count("SELECT COUNT(id) FROM `frends_new` WHERE `to` = '$user[id]'"), 
	); 

	return use_filters('ds_user_counters', $counter); 
}

function ds_user_panel() 
{
	do_event('user_panel_after'); 

	if (is_user()) {
		do_event('user_panel'); 
	} else {
		do_event('guest_panel'); 
	}

	do_event('user_panel_before'); 
}

function get_user_panel() 
{
	global $user; 
	$counter = get_user_counters(); 

	$template = array(); 
	$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/info.php?id=' . $user['id'] . '"><img src="/style/icons/nav_stranica.gif" alt="DS" /></a></div>'; 

	if ($counter['mail']['count'] > 0) {
		$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/new_mess.php"><img src="/style/icons/icon_pochta22.gif" alt="DS" /><span class="counter">(' . $counter['mail']['count'] . ')</span></a></div>'; 
	} else {
		$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/konts.php"><img src="/style/icons/nav_pochta.gif" alt="DS" /></a></div>'; 
	}
	
	$type = 'tape'; 
	if ($counter['tape']['count'] > 0) {
		$type = 'tape'; 
	} elseif ($counter['discussions']['count'] > 0) {
		$type = 'discussions'; 
	} elseif ($counter['notification']['count'] > 0) {
		$type = 'notification'; 
	}

	$counter_all = ($counter['tape']['count'] + $counter['discussions']['count'] + $counter['notification']['count']); 

	if ($counter_all) {
		$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/user/' . $type . '/"><img src="/style/icons/nav_lenta.gif" alt="DS" /><span class="counter">(' . $counter_all . ')</span></a></div>'; 
	} else {
		$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/user/' . $type . '/"><img src="/style/icons/nav_lenta.gif" alt="DS" /></a></div>'; 
	}

	if ($counter['friends']['count'] > 0) {
		$template[] = '<div class="panel-item"><a href="' . ds_site_url() . '/user/frends/new.php"><img src="/style/icons/icon_druzya.gif" alt="DS" /><span class="counter">(' . $counter['friends']['count'] . ')</span></a></div>'; 
	}
	
	$template[] = '<div class="panel-item"><a href="' . ds_site_url() . text($_SERVER['REQUEST_URI']) . '"><img src="/style/icons/nav_obnovit.gif" alt="DS" /></a></div>'; 
	
	echo '<div class="header-user-panel">' . implode('', $template) . '</div>'; 
}

/**
* Выход с сайта
*/ 
function ds_user_logout() 
{
	only_reg();
	setcookie('id_user');
	setcookie('pass');
	session_destroy();
	header('Location: ' . ds_site_url());
	exit;
}