<?php

function my_esc( $str )
{
    return db::esc( $str);
}

/**
 * Резервная функция мультиязычности
 * @return string
 */
function __($string) 
{ 
    $args = func_get_args();
    $args4eval = array();
    for ($i = 1; $i < count($args); $i++) {
        $args4eval[] = '$args[' . $i . ']';
    }
    
    if ($args4eval) {
        eval('$string = sprintf($string, ' . implode(', ', $args4eval) . ');');
    }
    
    return $string; 
}  

// антимат сделает автоматическое предупреждение, а затем бан
function antimat( $str )
{
    return false;
}

// рекурсивное удаление папки
function delete_dir( $dir )
{
    if ( is_dir( $dir ) ) {
        $od = opendir( $dir );
        while ( $rd = readdir( $od ) ) {
            if ( $rd == '.' || $rd == '..' )
                continue;
            if ( is_dir( "$dir/$rd" ) ) {
                @chmod( "$dir/$rd", 0777 );
                delete_dir( "$dir/$rd" );
            } else {
                @chmod( "$dir/$rd", 0777 );
                @unlink( "$dir/$rd" );
            }
        }
        closedir( $od );
        @chmod( $dir, 0777 );
        return @rmdir( $dir );
    } else {
        @chmod( $dir, 0777 );
        @unlink( $dir );
    }
}

function br( $msg, $br = '<br />' )
{
    return preg_replace( "#((<br( ?/?)>)|\n|\r)+#i", $br, $msg );
}

function esc( $text, $br = NULL )
{
    if ( $br != NULL )
        for ( $i = 0; $i <= 31; $i++ )
            $text = str_replace( chr( $i ), NULL, $text );
    else {
        for ( $i = 0; $i < 10; $i++ )
            $text = str_replace( chr( $i ), NULL, $text );
        for ( $i = 11; $i < 20; $i++ )
            $text = str_replace( chr( $i ), NULL, $text );
        for ( $i = 21; $i <= 31; $i++ )
            $text = str_replace( chr( $i ), NULL, $text );
    }
    return $text;
}

// определение оператора
function opsos( $ips = NULL )
{
    global $ip;
    if ( $ips == NULL )
        $ips = $ip;
    $ipl = ip2long( $ips );
    if ( db::count("SELECT COUNT(*) FROM `opsos` WHERE `min` <= '$ipl' AND `max` >= '$ipl'") != 0 ) {
        $opsos = db::fetch("SELECT opsos FROM `opsos` WHERE `min` <= '$ipl' AND `max` >= '$ipl' LIMIT 1", ARRAY_A);
        return stripcslashes( htmlspecialchars( $opsos['opsos'] ) );
    } else
        return false;
}

// вывод времени
function vremja( $time = NULL )
{
    global $user;
    if ( $time == NULL )
        $time = time();
    if ( isset( $user ) )
        $time = $time + $user['set_timesdvig'] * 60 * 60;
    $timep     = date( "j M Y в H:i", $time );
    $time_p[0] = date( "j n Y", $time );
    $time_p[1] = date( "H:i", $time );
    if ( $time_p[0] == date( "j n Y" ) )
        $timep = date( "H:i:s", $time );
    if ( isset( $user ) ) {
        if ( $time_p[0] == date( "j n Y", time() + $user['set_timesdvig'] * 60 * 60 ) )
            $timep = date( "H:i:s", $time );
        if ( $time_p[0] == date( "j n Y", time() - 60 * 60 * ( 24 - $user['set_timesdvig'] ) ) )
            $timep = "Вчера в $time_p[1]";
    } else {
        if ( $time_p[0] == date( "j n Y" ) )
            $timep = date( "H:i:s", $time );
        if ( $time_p[0] == date( "j n Y", time() - 60 * 60 * 24 ) )
            $timep = "Вчера в $time_p[1]";
    }
    $timep = str_replace( "Jan", "Янв", $timep );
    $timep = str_replace( "Feb", "Фев", $timep );
    $timep = str_replace( "Mar", "Марта", $timep );
    $timep = str_replace( "May", "Мая", $timep );
    $timep = str_replace( "Apr", "Апр", $timep );
    $timep = str_replace( "Jun", "Июня", $timep );
    $timep = str_replace( "Jul", "Июля", $timep );
    $timep = str_replace( "Aug", "Авг", $timep );
    $timep = str_replace( "Sep", "Сент", $timep );
    $timep = str_replace( "Oct", "Окт", $timep );
    $timep = str_replace( "Nov", "Ноября", $timep );
    $timep = str_replace( "Dec", "Дек", $timep );
    return $timep;
}

// только для зарегистрированых
function only_reg( $link = NULL )
{
    global $user;
    if ( !isset( $user ) ) {
        if ( $link == NULL )
            $link = '/index.php?' . SID;
        header( "Location: $link" );
        exit;
    }
}

// только для незарегистрированых
function only_unreg( $link = NULL )
{
    global $user;
    if ( isset( $user ) ) {
        if ( $link == NULL )
            $link = '/index.php?' . SID;
        header( "Location: $link" );
        exit;
    }
}

// только для тех, у кого уровень доступа больше или равен $level
function only_level( $level = 0, $link = NULL )
{
    global $user;
    if ( !isset( $user ) || $user['level'] < $level ) {
        if ( $link == NULL )
            $link = '/index.php?' . SID;
        header( "Location: $link" );
        exit;
    }
}

// вывод ошибок
function err( )
{
    global $err;
    if ( isset( $err ) ) {
        if ( is_array( $err ) ) {
            foreach ( $err as $key => $value ) {
                echo "<div class='err'>$value</div>\n";
            }
        } else
            echo "<div class='err'>$err</div>\n";
    }
}

function msg( $msg )
{
    echo "<div class='msg'>$msg</div>\n";
}

// сохранение настроек системы
function save_settings( $set, $type = '' )
{
    foreach($set AS $key => $value) {
        update_option($key, $value, $type); 
    }

    return true;
}

// запись действий администрации
function admin_log( $mod, $act, $opis )
{
    global $user;
    $q = db::query("SELECT * FROM `admin_log_mod` WHERE `name` = '" . my_esc( $mod ) . "' LIMIT 1");
    if (  $q->fetch_row() == 0 ) {
        db::query("INSERT INTO `admin_log_mod` (`name`) VALUES ('" . my_esc( $mod ) . "')");
        $id_mod = db::insert_id();
    } else
        $id_mod = $q->fetch_row();
    $q2 = db::query("SELECT * FROM `admin_log_act` WHERE `name` = '" . my_esc( $act ) . "' AND `id_mod` = '$id_mod' LIMIT 1");
    if (  $q2->fetch_row() == 0 ) {
        db::query("INSERT INTO `admin_log_act` (`name`, `id_mod`) VALUES ('" . my_esc( $act ) . "', '$id_mod')");
        $id_act = db::insert_id();
    } else
        $id_act = $q2->fetch_row();
    db::query("INSERT INTO `admin_log` (`time`, `id_user`, `mod`, `act`, `opis`) 
                  VALUES ('" . time() . "','$user[id]', '$id_mod', '$id_act', '" . my_esc( $opis ) . "')");
}